// File created 11/09/2005 09:27:31
unit CoreClassesUnit;

interface

uses
  System.Collections,
  Borland.Eco.Services,
  Borland.Eco.UmlRt,
  Borland.Eco.UmlCodeAttributes,
  Borland.Eco.ObjectImplementation,
  Borland.Eco.ObjectRepresentation;
type
  ResidentialBuilding = class;
  Person = class;
  Building = class;
  
  [UmlElement('Package', Id='48344c9f-17ee-42f4-92b2-e574bb863324')]
  [UmlMetaAttribute('ownedElement', TypeOf(ResidentialBuilding))]
  [UmlMetaAttribute('ownedElement', TypeOf(Person))]
  [UmlMetaAttribute('ownedElement', TypeOf(Building))]
  [EcoCodeGenVersion('2.0')]
  CoreClasses = class
  public
  type
    [UmlElement('Association', Id='ecc9edd5-07bb-4834-be2b-b407c27b3d0e')]
    Ownership = class
    end;
    
    [UmlElement('Association', Id='ff5dffb2-7023-4a37-befa-8da3826429de')]
    Residents = class
    end;
    
  end;
  IResidentialBuildingList = interface;
  IPersonList = interface;
  [UmlCollection(TypeOf(ResidentialBuilding))]
  IResidentialBuildingList = interface(ICollection)
    {$REGION 'ECO generated code'}
    function get_Item(index: Integer): ResidentialBuilding;
    procedure set_Item(index: Integer; Value: ResidentialBuilding);
    property Item[index: Integer]: ResidentialBuilding read get_Item write set_Item; default;
    function Add(value: ResidentialBuilding): Integer;
    function Contains(value: ResidentialBuilding): Boolean;
    function IndexOf(value: ResidentialBuilding): Integer;
    procedure Insert(index: Integer; value: ResidentialBuilding);
    procedure Remove(value: ResidentialBuilding);
    procedure Clear;
    procedure RemoveAt(index: Integer);
    {$ENDREGION 'ECO generated code'}
  end;
  IBuildingList = interface;
  [UmlCollection(TypeOf(Person))]
  IPersonList = interface(ICollection)
    {$REGION 'ECO generated code'}
    function get_Item(index: Integer): Person;
    procedure set_Item(index: Integer; Value: Person);
    property Item[index: Integer]: Person read get_Item write set_Item; default;
    function Add(value: Person): Integer;
    function Contains(value: Person): Boolean;
    function IndexOf(value: Person): Integer;
    procedure Insert(index: Integer; value: Person);
    procedure Remove(value: Person);
    procedure Clear;
    procedure RemoveAt(index: Integer);
    {$ENDREGION 'ECO generated code'}
  end;
  
  [UmlElement(Id='83f5247d-870e-4ad5-99a5-584fd9b795f0')]
  [UmlTaggedValue('Eco.DefaultStringRepresentation', 'fullName')]
  Person = class(System.Object, ILoopBack)
    {$REGION 'ECO generated code'}
  public
  type
    Eco_LoopbackIndices = class
    public
    const
      Eco_FirstMember = 0;
    const
      Eco_MemberCount = (Eco_FirstMember + 6);
    const
      firstName = Eco_FirstMember;
    const
      fullName = (Eco_LoopbackIndices.firstName + 1);
    const
      lastName = (Eco_LoopbackIndices.fullName + 1);
    const
      assets = (Eco_LoopbackIndices.lastName + 1);
    const
      ownedBuilding = (Eco_LoopbackIndices.assets + 1);
    const
      home = (Eco_LoopbackIndices.ownedBuilding + 1);
    end;

    PersonListAdapter = class(ObjectListAdapter, IPersonList)
    public
      constructor Create(source: IList);
      function get_Item(index: Integer): Person;
      procedure set_Item(index: Integer; Value: Person);
      property Item[index: Integer]: Person read get_Item write set_Item; default;
      function Add(value: Person): Integer;
      function Contains(value: Person): Boolean;
      function IndexOf(value: Person): Integer;
      procedure Insert(index: Integer; value: Person);
      procedure Remove(value: Person);
    end;
    
  strict protected
    eco_Content: IContent;
  strict private
    function IObjectProvider.AsIObject = IObjectProvider_AsIObject;
    function IObjectProvider_AsIObject: IObject;
  public
    function AsIObject: IObjectInstance;
    procedure set_MemberByIndex(index: Integer; value: System.Object); virtual;
    function get_MemberByIndex(index: Integer): System.Object; virtual;
  strict protected
    procedure Deinitialize(serviceProvider: IEcoServiceProvider);
    procedure Initialize(serviceProvider: IEcoServiceProvider);
    /// <summary>For Framework Internal use only</summary>
  public
    constructor Create(content: IContent); overload;
    {$ENDREGION 'ECO generated code'}
    constructor Create(serviceProvider: IEcoServiceProvider); overload;
    function get_firstName: string;
    procedure set_firstName(Value: string);
    [UmlElement(Id='35448232-8d56-44f6-af99-cf6815aec861', Index=Eco_LoopbackIndices.firstName)]
    [UmlMetaAttribute('initialValue', '<first>')]
    property firstName: string read get_firstName write set_firstName;
    function get_fullName: string;
    [UmlElement(Id='458f1a00-f76b-4364-92ef-ebafd48a5b61', Index=Eco_LoopbackIndices.fullName)]
    [UmlTaggedValue('Eco.DerivationOCL', 'firstName + '' '' + lastName')]
    [UmlTaggedValue('derived', 'true')]
    property fullName: string read get_fullName;
    function get_lastName: string;
    procedure set_lastName(Value: string);
    [UmlElement(Id='626eeb60-9bac-462c-af81-bd7a55bfdbb0', Index=Eco_LoopbackIndices.lastName)]
    [UmlMetaAttribute('initialValue', '<last>')]
    property lastName: string read get_lastName write set_lastName;
    function get_assets: Double;
    procedure set_assets(Value: Double);
    [UmlElement(Id='ed36543c-4fd5-4fa7-aa04-bbae9a91d59a', Index=Eco_LoopbackIndices.assets)]
    property assets: Double read get_assets write set_assets;
    function get_ownedBuilding: IBuildingList;
    [UmlElement('AssociationEnd', Index=Eco_LoopbackIndices.ownedBuilding, Id='12' +
    'fed006-bb7b-4ed8-9f82-306776aba2f1')]
    [UmlMetaAttribute('association', TypeOf(CoreClasses.Ownership), Index=1)]
    [UmlMetaAttribute('multiplicity', '0..*')]
    property ownedBuilding: IBuildingList read get_ownedBuilding;
    function get_home: ResidentialBuilding;
    procedure set_home(Value: ResidentialBuilding);
    [UmlElement('AssociationEnd', Index=Eco_LoopbackIndices.home, Id='f8b90957-4e' +
    '89-4aae-939f-c4edbbbec76f')]
    [UmlMetaAttribute('association', TypeOf(CoreClasses.Residents), Index=1)]
    [UmlMetaAttribute('multiplicity', '0..1')]
    property home: ResidentialBuilding read get_home write set_home;
    [UmlElement(Id='31d6f96a-cc04-46df-959a-496b627ddee8')]
    procedure Payrent;
  end;
  [UmlCollection(TypeOf(Building))]
  IBuildingList = interface(ICollection)
    {$REGION 'ECO generated code'}
    function get_Item(index: Integer): Building;
    procedure set_Item(index: Integer; Value: Building);
    property Item[index: Integer]: Building read get_Item write set_Item; default;
    function Add(value: Building): Integer;
    function Contains(value: Building): Boolean;
    function IndexOf(value: Building): Integer;
    procedure Insert(index: Integer; value: Building);
    procedure Remove(value: Building);
    procedure Clear;
    procedure RemoveAt(index: Integer);
    {$ENDREGION 'ECO generated code'}
  end;
  
  [UmlElement(Id='022bc5f1-9304-428a-a32c-d81f995023da')]
  [UmlTaggedValue('Eco.DefaultStringRepresentation', 'address')]
  Building = class(System.Object, ILoopBack)
    {$REGION 'ECO generated code'}
  public
  type
    Eco_LoopbackIndices = class
    public
    const
      Eco_FirstMember = 0;
    const
      Eco_MemberCount = (Eco_FirstMember + 4);
    const
      taxationValue = Eco_FirstMember;
    const
      ownerShare = (Eco_LoopbackIndices.taxationValue + 1);
    const
      address = (Eco_LoopbackIndices.ownerShare + 1);
    const
      owner = (Eco_LoopbackIndices.address + 1);
    end;

    BuildingListAdapter = class(ObjectListAdapter, IBuildingList)
    public
      constructor Create(source: IList);
      function get_Item(index: Integer): Building;
      procedure set_Item(index: Integer; Value: Building);
      property Item[index: Integer]: Building read get_Item write set_Item; default;
      function Add(value: Building): Integer;
      function Contains(value: Building): Boolean;
      function IndexOf(value: Building): Integer;
      procedure Insert(index: Integer; value: Building);
      procedure Remove(value: Building);
    end;
    
  strict protected
    eco_Content: IContent;
  strict private
    function IObjectProvider.AsIObject = IObjectProvider_AsIObject;
    function IObjectProvider_AsIObject: IObject;
  public
    function AsIObject: IObjectInstance;
    procedure set_MemberByIndex(index: Integer; value: System.Object); virtual;
    function get_MemberByIndex(index: Integer): System.Object; virtual;
  strict protected
    procedure Deinitialize(serviceProvider: IEcoServiceProvider);
    procedure Initialize(serviceProvider: IEcoServiceProvider);
    /// <summary>For Framework Internal use only</summary>
  public
    constructor Create(content: IContent); overload;
    {$ENDREGION 'ECO generated code'}
    constructor Create(serviceProvider: IEcoServiceProvider); overload;
    function get_taxationValue: Double;
    procedure set_taxationValue(Value: Double);
    [UmlElement(Id='07beda3e-dee9-4081-8154-39fb667f64a7', Index=Eco_LoopbackIndices.taxationValue)]
    property taxationValue: Double read get_taxationValue write set_taxationValue;
    function get_ownerShare: Double;
    [UmlElement(Id='60c3c5a8-47bc-41b7-8ddd-a39e607515ca', Index=Eco_LoopbackIndices.ownerShare)]
    [UmlTaggedValue('Eco.DerivationOCL', ('if owner->size = 0 then 0.0 else ' +
    't' + 'axationValue/owner->size endif'))]
    [UmlTaggedValue('derived', 'true')]
    property ownerShare: Double read get_ownerShare;
    function get_address: string;
    procedure set_address(Value: string);
    [UmlElement(Id='c8e60b4b-de30-4738-a052-60887b7b2578', Index=Eco_LoopbackIndices.address)]
    [UmlMetaAttribute('initialValue', '<new>')]
    property address: string read get_address write set_address;
    function get_owner: IPersonList;
    [UmlElement('AssociationEnd', Index=Eco_LoopbackIndices.owner, Id='1682d50b-8' +
    'ae6-42b7-90f6-41d3603422b5')]
    [UmlMetaAttribute('association', TypeOf(CoreClasses.Ownership), Index=0)]
    [UmlMetaAttribute('multiplicity', '0..*')]
    property owner: IPersonList read get_owner;
  end;
  
  [UmlElement(Id='b8b6f7d7-8a8e-49c8-a421-46ad3d68d097')]
  ResidentialBuilding = class(Building)
  public
  type
    ResidentialBuildingListAdapter = class(ObjectListAdapter, IResidentialBuildingList)
    public
      constructor Create(source: IList);
      function get_Item(index: Integer): ResidentialBuilding;
      procedure set_Item(index: Integer; Value: ResidentialBuilding);
      property Item[index: Integer]: ResidentialBuilding read get_Item 
        write set_Item; default;
      function Add(value: ResidentialBuilding): Integer;
      function Contains(value: ResidentialBuilding): Boolean;
      function IndexOf(value: ResidentialBuilding): Integer;
      procedure Insert(index: Integer; value: ResidentialBuilding);
      procedure Remove(value: ResidentialBuilding);
    end;
    {$REGION 'ECO generated code'}
  public
  type
    Eco_LoopbackIndices = class
    public
    const
      Eco_FirstMember = Building.Eco_LoopbackIndices.Eco_MemberCount;
    const
      Eco_MemberCount = (Eco_FirstMember + 2);
    const
      totalRent = Eco_FirstMember;
    const
      resident = (Eco_LoopbackIndices.totalRent + 1);
    end;
    
    /// <summary>For Framework Internal use only</summary>
    constructor Create(content: IContent); overload;
    {$ENDREGION 'ECO generated code'}
    constructor Create(serviceProvider: IEcoServiceProvider); overload;
    function get_totalRent: Double;
    procedure set_totalRent(Value: Double);
    [UmlElement(Id='2ad07de3-c7f3-40fa-8977-39448e313588', Index=Eco_LoopbackIndices.totalRent)]
    property totalRent: Double read get_totalRent write set_totalRent;
    function get_resident: IPersonList;
    [UmlElement('AssociationEnd', Index=Eco_LoopbackIndices.resident, Id='ddde2fd' +
    '8-754a-4448-ab57-bdb0fd63520d')]
    [UmlMetaAttribute('association', TypeOf(CoreClasses.Residents), Index=0)]
    [UmlMetaAttribute('multiplicity', '0..*')]
    property resident: IPersonList read get_resident;
    [UmlElement(Id='941d3a91-def6-4361-a168-ff111126c34c')]
    procedure ChargeRent;
  end;
  
  [assembly: RuntimeRequiredAttribute(TypeOf(CoreClasses))]

implementation

/// <summary>For Framework Internal use only</summary>
constructor ResidentialBuilding.Create(content: IContent);
begin
  inherited Create(content);
end;

{$ENDREGION 'ECO generated code'}

constructor ResidentialBuilding.Create(serviceProvider: IEcoServiceProvider);
begin
  inherited Create(serviceProvider);
  try
    // User code here
  except
    on System.Exception do
    begin
      Self.Deinitialize(serviceProvider);
      raise;
    end;
  end;
end;

function ResidentialBuilding.get_totalRent: Double;
begin
  Result := (Double(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.totalRent)));
end;

procedure ResidentialBuilding.set_totalRent(Value: Double);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.totalRent, (System.Object(Value)));
end;

function ResidentialBuilding.get_resident: IPersonList;
begin
  Result := CoreClassesUnit.Person.PersonListAdapter.Create((IList(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.resident))));
end;

procedure ResidentialBuilding.ChargeRent;
var
  r: Person;
begin
  for r in resident do
    r.Payrent;
end;

constructor ResidentialBuilding.ResidentialBuildingListAdapter.Create(source: IList);
begin
  inherited Create(source);
end;

function ResidentialBuilding.ResidentialBuildingListAdapter.get_Item(index: Integer): 
  ResidentialBuilding;
begin
  Result := (ResidentialBuilding(inherited Adaptee[index]));
end;

procedure ResidentialBuilding.ResidentialBuildingListAdapter.set_Item(index: Integer; Value: ResidentialBuilding);
begin
  inherited Adaptee[index] := value;
end;

function ResidentialBuilding.ResidentialBuildingListAdapter.Add(value: ResidentialBuilding): Integer;
begin
  Result := Self.Adaptee.Add(value);
end;

function ResidentialBuilding.ResidentialBuildingListAdapter.Contains(value: ResidentialBuilding): Boolean;
begin
  Result := Self.Adaptee.Contains(value);
end;

function ResidentialBuilding.ResidentialBuildingListAdapter.IndexOf(value: ResidentialBuilding): Integer;
begin
  Result := Self.Adaptee.IndexOf(value);
end;

procedure ResidentialBuilding.ResidentialBuildingListAdapter.Insert(index: Integer; 
  value: ResidentialBuilding);
begin
  Self.Adaptee.Insert(index, value);
end;

procedure ResidentialBuilding.ResidentialBuildingListAdapter.Remove(value: ResidentialBuilding);
begin
  Self.Adaptee.Remove(value);
end;

function Person.IObjectProvider_AsIObject: IObject;
begin
  Result := Self.eco_Content.AsIObject;
end;

function Person.AsIObject: IObjectInstance;
begin
  Result := Self.eco_Content.AsIObject;
end;

procedure Person.set_MemberByIndex(index: Integer; value: System.Object);
begin
  raise System.IndexOutOfRangeException.Create;
end;

function Person.get_MemberByIndex(index: Integer): System.Object;
begin
  raise System.IndexOutOfRangeException.Create;
end;

procedure Person.Deinitialize(serviceProvider: IEcoServiceProvider);
var
  factory: IInternalObjectContentFactory;
begin
  if (Self.eco_Content <> nil) then
  begin
    factory := (IInternalObjectContentFactory(serviceProvider.GetEcoService(TypeOf(IInternalObjectContentFactory))));
    factory.CreateContentFailed(Self.eco_Content, Self);
    Self.eco_Content := nil;
  end;
end;

procedure Person.Initialize(serviceProvider: IEcoServiceProvider);
var
  factory: IInternalObjectContentFactory;
begin
  if (Self.eco_Content = nil) then
  begin
    factory := (IInternalObjectContentFactory(serviceProvider.GetEcoService(TypeOf(IInternalObjectContentFactory))));
    Self.eco_Content := factory.CreateContent(Self);
    Self.eco_Content.LoopbackValid;
  end;
end;

/// <summary>For Framework Internal use only</summary>
constructor Person.Create(content: IContent);
begin
  inherited Create;
  Self.eco_Content := content;
  content.AssertLoopbackUnassigned;
end;

{$ENDREGION 'ECO generated code'}

constructor Person.Create(serviceProvider: IEcoServiceProvider);
begin
  inherited Create;
  Self.Initialize(serviceProvider);
  try
    // User code here
  except
    on System.Exception do
    begin
      Self.Deinitialize(serviceProvider);
      raise;
    end;
  end;
end;

function Person.get_firstName: string;
begin
  Result := (string(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.firstName)));
end;

procedure Person.set_firstName(Value: string);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.firstName, (System.Object(Value)));
end;

function Person.get_fullName: string;
begin
  Result := (string(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.fullName)));
end;

function Person.get_lastName: string;
begin
  Result := (string(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.lastName)));
end;

procedure Person.set_lastName(Value: string);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.lastName, (System.Object(Value)));
end;

function Person.get_assets: Double;
begin
  Result := (Double(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.assets)));
end;

procedure Person.set_assets(Value: Double);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.assets, (System.Object(Value)));
end;

function Person.get_ownedBuilding: IBuildingList;
begin
  Result := CoreClassesUnit.Building.BuildingListAdapter.Create((IList(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.ownedBuilding))));
end;

function Person.get_home: ResidentialBuilding;
begin
  Result := (CoreClassesUnit.ResidentialBuilding(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.home)));
end;

procedure Person.set_home(Value: ResidentialBuilding);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.home, (System.Object(Value)));
end;

procedure Person.Payrent;
var
  landlord: Person;
  collectible,
  payable: double;
begin
  if not Assigned(Home) then Exit;
  payable := Home.totalRent / Home.resident.Count;
  collectible := payable / Home.owner.Count;

  for landlord in Home.owner do
    landlord.Assets := landlord.Assets + collectible;

  Assets := Assets - payable;
end;

constructor Person.PersonListAdapter.Create(source: IList);
begin
  inherited Create(source);
end;

function Person.PersonListAdapter.get_Item(index: Integer): Person;
begin
  Result := (Person(inherited Adaptee[index]));
end;

procedure Person.PersonListAdapter.set_Item(index: Integer; Value: Person);
begin
  inherited Adaptee[index] := value;
end;

function Person.PersonListAdapter.Add(value: Person): Integer;
begin
  Result := Self.Adaptee.Add(value);
end;

function Person.PersonListAdapter.Contains(value: Person): Boolean;
begin
  Result := Self.Adaptee.Contains(value);
end;

function Person.PersonListAdapter.IndexOf(value: Person): Integer;
begin
  Result := Self.Adaptee.IndexOf(value);
end;

procedure Person.PersonListAdapter.Insert(index: Integer; value: Person);
begin
  Self.Adaptee.Insert(index, value);
end;

procedure Person.PersonListAdapter.Remove(value: Person);
begin
  Self.Adaptee.Remove(value);
end;

function Building.IObjectProvider_AsIObject: IObject;
begin
  Result := Self.eco_Content.AsIObject;
end;

function Building.AsIObject: IObjectInstance;
begin
  Result := Self.eco_Content.AsIObject;
end;

procedure Building.set_MemberByIndex(index: Integer; value: System.Object);
begin
  raise System.IndexOutOfRangeException.Create;
end;

function Building.get_MemberByIndex(index: Integer): System.Object;
begin
  raise System.IndexOutOfRangeException.Create;
end;

procedure Building.Deinitialize(serviceProvider: IEcoServiceProvider);
var
  factory: IInternalObjectContentFactory;
begin
  if (Self.eco_Content <> nil) then
  begin
    factory := (IInternalObjectContentFactory(serviceProvider.GetEcoService(TypeOf(IInternalObjectContentFactory))));
    factory.CreateContentFailed(Self.eco_Content, Self);
    Self.eco_Content := nil;
  end;
end;

procedure Building.Initialize(serviceProvider: IEcoServiceProvider);
var
  factory: IInternalObjectContentFactory;
begin
  if (Self.eco_Content = nil) then
  begin
    factory := (IInternalObjectContentFactory(serviceProvider.GetEcoService(TypeOf(IInternalObjectContentFactory))));
    Self.eco_Content := factory.CreateContent(Self);
    Self.eco_Content.LoopbackValid;
  end;
end;

/// <summary>For Framework Internal use only</summary>
constructor Building.Create(content: IContent);
begin
  inherited Create;
  Self.eco_Content := content;
  content.AssertLoopbackUnassigned;
end;

{$ENDREGION 'ECO generated code'}

constructor Building.Create(serviceProvider: IEcoServiceProvider);
begin
  inherited Create;
  Self.Initialize(serviceProvider);
  try
    // User code here
  except
    on System.Exception do
    begin
      Self.Deinitialize(serviceProvider);
      raise;
    end;
  end;
end;

function Building.get_taxationValue: Double;
begin
  Result := (Double(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.taxationValue)));
end;

procedure Building.set_taxationValue(Value: Double);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.taxationValue, (System.Object(Value)));
end;

function Building.get_ownerShare: Double;
begin
  Result := (Double(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.ownerShare)));
end;

function Building.get_address: string;
begin
  Result := (string(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.address)));
end;

procedure Building.set_address(Value: string);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.address, (System.Object(Value)));
end;

function Building.get_owner: IPersonList;
begin
  Result := CoreClassesUnit.Person.PersonListAdapter.Create((IList(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.owner))));
end;

constructor Building.BuildingListAdapter.Create(source: IList);
begin
  inherited Create(source);
end;

function Building.BuildingListAdapter.get_Item(index: Integer): Building;
begin
  Result := (Building(inherited Adaptee[index]));
end;

procedure Building.BuildingListAdapter.set_Item(index: Integer; Value: Building);
begin
  inherited Adaptee[index] := value;
end;

function Building.BuildingListAdapter.Add(value: Building): Integer;
begin
  Result := Self.Adaptee.Add(value);
end;

function Building.BuildingListAdapter.Contains(value: Building): Boolean;
begin
  Result := Self.Adaptee.Contains(value);
end;

function Building.BuildingListAdapter.IndexOf(value: Building): Integer;
begin
  Result := Self.Adaptee.IndexOf(value);
end;

procedure Building.BuildingListAdapter.Insert(index: Integer; value: Building);
begin
  Self.Adaptee.Insert(index, value);
end;

procedure Building.BuildingListAdapter.Remove(value: Building);
begin
  Self.Adaptee.Remove(value);
end;

end.
